(() => {
  // Finds all links inside table cells that have the 'sel' class
  const links = Array.from(document.querySelectorAll('.sel a[href^="/download/"]'))
    .map(a => a.href);

  if (links.length > 0) {
    const output = links.join('\n');
    copy(output);
    console.log(`✅ ${links.length} links copied!`);
    console.table(links);
  } else {
    console.warn("No links found in selected rows. Try running: console.log(document.querySelectorAll('.sel')) to check the class name.");
  }
})();